

var AJAX = new Object();



//Constantes

AJAX.READY_STATE_UNINITIALIZED	=	0;

AJAX.READY_STATE_LOADING		=	1;

AJAX.READY_STATE_LOADED			=	2;

AJAX.READY_STATE_INTERACTIVE	=	3;

AJAX.READY_STATE_COMPLETE		=	4;



AJAX.GET		=	"GET";

AJAX.POST		=	"POST";



/**

 * Constructor request()

 * Realiza una peticin AJAX a la url especificada

 * con las opciones definidas

 *

 * @param {String} url La URL, donde realizar la peticin, puede ser una direccin relativa o absoluta

 * @param {Object} funcionOK, es el nombre de la funcion sinparentesis, que se ejecutar cuando la peticin concluyo satisfactoriamente

 * @param {Object} funcionError, es el nombre de la funcion sinparentesis, que se ejecutar cuando la peticin no concluy o se produjeron errores,

 *				   este valor es opcional, si no se introduce, se jecuta la funcin de error por defecto que contiene la clase.

 * @param {String} metodo, es el metodo por el cual se solicita la peticin al servidor: GET o POST

 * @param {String} parametros, es una cadena en formato: variable1=valor1&variable2=valor2&........ formato par valor separados por &

 * @param (String) id, es el id de la seccin de la pagina donde se mostrar el resultado, esto es con el fin de enviar hasta las funciones

 *				   que ejecutan el resultado el nombre de la seccin donde se mostrar finalmente dicho resultado

 * 

 */

AJAX.request = function(url, funcionOK, funcionError, metodo, parametros, id){

	this.url = url;

	this.req = null;

	this.onload = funcionOK;

	this.onerror = (funcionError) ? funcionError : this.defaultError;

	this.cargaContenidoXML(url, metodo, parametros);

	this.id = id;

}



//Prototipo del constructor

AJAX.request.prototype = {

	

	cargaContenidoXML: function(url, metodo, parametros) {

		if (window.XMLHttpRequest) {

			this.req = new XMLHttpRequest();

		} else if (window.ActiveXObject) {

			this.req = new ActiveXObject("Microsoft.XMLHTTP");

		}

		

		if(this.req) {

			try {

				var loader = this;

				this.req.onreadystatechange = function() {

					loader.onReadyState.call(loader);

				}

				

				if(AJAX.POST == metodo) {

					//this.req.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");

				}

				if(parametros != ""){

					var aleatorio=Math.random(); 

					url += "?" + parametros;

					url += "&nocache=" + aleatorio;

				}

				

				this.req.open(metodo, url, true);

				this.req.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");

				this.req.setRequestHeader("Content-Type", "text/html; charset=iso-8859-1");

				this.req.setRequestHeader("Cache-Control", "no-cache");

				this.req.send(parametros);

				

				

			} catch (err) {

				this.onerror.call(this);

			}

		}

	},

	

	onReadyState: function() {

		var req = this.req;

		var ready = req.readyState;

		if (ready == AJAX.READY_STATE_COMPLETE) {

			var httpStatus = req.status;

			if(httpStatus == 200 || httpStatus == 0) {

				this.onload.call(this);

			}else {

				this.onerror.call(this);

			}

		}

	},

	

	defaultError: function() {

		alert("Se ha producido un error al obtener los datos"

		+ "\n\nreadyState:" + this.req.readyState

		+ "\nstatus: " + this.req.status

		+ "\nheaders: " + this.req.getAllResponseHeaders());

	}

}